<?PHP 
	$this->load->view('api/header'); 
	$this->load->view('api/nav'); 
	$this->load->helper('form');
?>
				<div id="success">&nbsp;</div>
				<div id="error">&nbsp;</div>
				<h1>Onboarding Request</h1>
				<div class="column">
					<?PHP if(isset($validation_errors)) { echo '<div class="message_error">'.$validation_errors.'</div>'; } ?>
					<?PHP if(isset($error_message)) { echo '<div class="message_error">'.$error_message.'</div>'; } ?>
					<?php if($request->denied > 0 && $request->denial_reason){?>
						<div class="message">
							<p>This application has been denied for the following reason:</p>
							<p class="denial-reason"><?php echo $request->denial_reason; ?></p>
							<p>Please update the request and resubmit.</p>
						</div>
					<?php } ?>
					<p>Please fill out all fields in the following form to update your application request details.</p>
					<?PHP echo form_open('/onboarding/app_request_save',array('id'=>'requestForm')); ?>
						<div class="form">
							<?PHP echo form_hidden('app_id',$request->id,'app_id'); ?>
							<label for="app_name">Application Name:</label>
							<p class="hidden_context">Help Text for Application Name: Please enter the name of the application requesting access.</p> 
							<input class="ttFocus" title="Please enter the name of the application requesting access." type="text" name="app_name" id="app_name" value="<?php if(isset($error_message)){echo $app_name;}else{echo $request->name;} ?>"/>
							
							<label for="app_url">Application URL:</label>
							<p class="hidden_context">Help Text for Application URL: Please enter the URL of the application requesting access.</p> 
							<input class="ttFocus" title="Please enter the URL of the application requesting access." type="text" name="app_url" id="app_url" value="<?php if(isset($error_message)){echo $app_url;}else{echo $request->url;} ?>"/>
							
							<label for="app_desc">Application Description:</label>
							<p class="hidden_context">Help Text for Application Description: Please enter a description of the application requesting access.</p> 
							<textarea class="ttFocus" title="Please enter a description of the application requesting access." name="app_desc" id="app_desc"><?php if(isset($error_message)){echo $app_desc;}else{echo $request->description;} ?></textarea>
							
							<label for="app_just">Justification:</label> 
							<p class="hidden_context">Help Text for Justification: Please enter a justification for why this application needs access to <?PHP echo PRODUCT_NAME;?>.</p>
							<textarea class="ttFocus" title="Please enter a justification for why this application needs access to <?PHP echo PRODUCT_NAME;?>." name="app_just" id="app_just"><?php if(isset($error_message)){echo $app_just;}else{echo $request->justification;} ?></textarea>
							
							<label for="app_poc_name">POC Name:</label> 
							<p class="hidden_context">Help Text for POC Name: Please enter a Point of Contact who can speak for the application and explain their needs to the <?PHP echo PRODUCT_NAME;?> Administrators.</p>
							<input class="ttFocus" title="Please enter a Point of Contact who can speak for the application and explain their needs to the <?PHP echo PRODUCT_NAME;?> Administrators." type="text" name="app_poc_name" id="app_poc_name" value="<?php if(isset($error_message)){echo $poc_name;}else{echo $request->poc_name;} ?>"/>
							
							<label for="app_poc_email">POC External Email:</label> 
							<p class="hidden_context">Help Text for POC External Email: Please enter the email address of the POC above.</p>
							<input class="ttFocus" title="Please enter the email address of the POC above." type="text" name="app_poc_email" id="app_poc_email" value="<?php if(isset($error_message)){echo $poc_email;}else{echo $request->poc_email;} ?>"/>
							
							<label for="app_poc_phone">POC Phone:</label> 
							<p class="hidden_context">Help Text for POC Phone: Please enter the phone number of the POC above.</p>
							<input class="ttFocus" title="Please enter the phone number of the POC above." type="text" name="app_poc_phone" id="app_poc_phone" value="<?php if(isset($error_message)){echo $poc_phone;}else{echo $request->poc_phone;} ?>"/>
							
						</div>	
						<div class="text-right"><input class="blue-button" type="submit" value="Save"/></div>	
					<?PHP echo form_close(); ?>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>